/*
---------------------- Apache Version 2.0 License ----------------------
Copyright 2023 René Steger

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
------------------------------------------------------------------------
*/

-- create an instance of the Rexx class
rexxHandler=.RexxAppHandler~new
-- the abstract "start" method will be served by rexxHandler
rxApp=BSFCreateRexxProxy(rexxHandler, ,"javafx.application.Application")
-- launch the application and invokes "start"
rxApp~launch(rxApp~getClass, .nil)

-- get Java Support
::REQUIRES "BSF.CLS"

-- the Rexx handler for javafx.application.Application
::CLASS RexxAppHandler

-- will be called by JavaFX
::METHOD start
-- accesses the primary stage
USE ARG primaryStage

-- setting title to the Stage
primaryStage~setTitle("Sphere_PerspectiveCamera")

-- create the root node
root=.bsf~new("javafx.scene.Group")

-- create a sphere
sphere=.bsf~new("javafx.scene.shape.Sphere")
-- set the radius of the sphere
sphere~radius=75
-- set position of the sphere
sphere~translateX=150
sphere~translateY=150

-- add the object to the root node
root~getChildren~~add(sphere)

-- create a perspective camera
camera=.bsf~new("javafx.scene.PerspectiveCamera")
-- set position of the camera
camera~translateX=100
camera~translateY=100
camera~translateZ=-100

-- create a scene
scene=.bsf~new("javafx.scene.Scene", root, 800, 600)
-- add camera to the scene
scene~setCamera(camera)

-- put the scene on the stage
primaryStage~setScene(scene)
-- display the content of the stage
primaryStage~show